/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.BuildInfoExtractor;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.builder.ArtifactBuilder;
import org.jfrog.build.extractor.builder.BuildInfoMavenBuilder;
import org.jfrog.build.extractor.builder.DependencyBuilder;
import org.jfrog.build.extractor.builder.ModuleBuilder;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.maven.BuildDeploymentHelper;
import org.jfrog.build.extractor.maven.BuildInfoModelPropertyResolver;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Component(role=BuildInfoRecorder.class)
public class BuildInfoRecorder
extends AbstractExecutionListener
implements BuildInfoExtractor<ExecutionEvent> {
    @Requirement
    private BuildInfoModelPropertyResolver buildInfoModelPropertyResolver;
    @Requirement
    private BuildDeploymentHelper buildDeploymentHelper;
    @Requirement
    private ResolutionHelper resolutionHelper;
    @Requirement
    private Logger logger;
    private final Set<org.apache.maven.artifact.Artifact> resolvedArtifacts = Collections.synchronizedSet(new HashSet());
    private final ThreadLocal<Set<org.apache.maven.artifact.Artifact>> currentModuleDependencies = new ThreadLocal();
    private final ThreadLocal<Set<org.apache.maven.artifact.Artifact>> currentModuleArtifacts = new ThreadLocal();
    private final ThreadLocal<ModuleBuilder> currentModule = new ThreadLocal();
    private Map<String, DeployDetails> deployableArtifactBuilderMap;
    private Map<String, String[][]> dependencyParentsMaps;
    private volatile boolean projectHasTestFailures;
    private BuildInfoMavenBuilder buildInfoBuilder;
    private ArtifactoryClientConfiguration conf;
    private ExecutionListener wrappedListener;
    private DocumentBuilder documentBuilder;
    private final ThreadLocal<XPathExpression> xPathExpression = new ThreadLocal<XPathExpression>(){

        @Override
        protected XPathExpression initialValue() {
            XPathExpression result = null;
            try {
                result = XPathFactory.newInstance().newXPath().compile("/testsuite/@failures>0 or /testsuite/@errors>0");
            }
            catch (XPathExpressionException ex) {
                BuildInfoRecorder.this.logger.error("Fail to create XPathExpression", (Throwable)ex);
            }
            return result;
        }
    };

    public void setListenerToWrap(ExecutionListener executionListener) {
        this.wrappedListener = executionListener;
    }

    public void setConfiguration(ArtifactoryClientConfiguration conf) {
        this.conf = conf;
    }

    public void setDependencyParentsMaps(Map<String, String[][]> dependencyParentsMaps) {
        this.dependencyParentsMaps = dependencyParentsMaps;
    }

    public void artifactResolved(org.apache.maven.artifact.Artifact artifact) {
        if (artifact != null) {
            this.resolvedArtifacts.add(artifact);
        }
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.projectDiscoveryStarted(event);
        }
    }

    public void sessionStarted(ExecutionEvent event) {
        try {
            this.logger.info("Initializing Artifactory Build-Info Recording");
            this.buildInfoBuilder = this.buildInfoModelPropertyResolver.resolveProperties(event, this.conf);
            this.deployableArtifactBuilderMap = new ConcurrentHashMap<String, DeployDetails>();
            this.setDeploymentPolicy(event);
            if (this.wrappedListener != null) {
                this.wrappedListener.sessionStarted(event);
            }
        }
        catch (Throwable t) {
            String message = ((Object)((Object)this)).getClass().getName() + ".sessionStarted() listener has failed: ";
            this.logger.error(message, t);
            throw new RuntimeException(message, t);
        }
    }

    public void sessionEnded(ExecutionEvent event) {
        File file;
        String propertyFilePath;
        block11: {
            try {
                BuildInfo buildInfo = this.extract(event);
                if (buildInfo != null) {
                    File basedir = event.getSession().getTopLevelProject().getBasedir();
                    this.buildDeploymentHelper.deploy(buildInfo, this.conf, this.deployableArtifactBuilderMap, this.projectHasTestFailures, basedir);
                }
                this.deployableArtifactBuilderMap.clear();
                if (this.wrappedListener == null) break block11;
                this.wrappedListener.sessionEnded(event);
            }
            catch (Throwable t) {
                try {
                    String message = ((Object)((Object)this)).getClass().getName() + ".sessionEnded() listener has failed: ";
                    this.logger.error(message, t);
                    throw new RuntimeException(message, t);
                }
                catch (Throwable throwable) {
                    File file2;
                    String propertyFilePath2 = System.getenv("buildInfoConfig.propertiesFile");
                    if (StringUtils.isBlank((CharSequence)propertyFilePath2)) {
                        propertyFilePath2 = this.conf.getPropertiesFile();
                    }
                    if (StringUtils.isNotBlank((CharSequence)propertyFilePath2) && (file2 = new File(propertyFilePath2)).exists()) {
                        boolean deleteFailed;
                        boolean bl = deleteFailed = !file2.delete();
                        if (deleteFailed) {
                            this.logger.warn("Failed to delete properties file with sensitive data: " + propertyFilePath2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)(propertyFilePath = System.getenv("buildInfoConfig.propertiesFile")))) {
            propertyFilePath = this.conf.getPropertiesFile();
        }
        if (StringUtils.isNotBlank((CharSequence)propertyFilePath) && (file = new File(propertyFilePath)).exists()) {
            boolean deleteFailed;
            boolean bl = deleteFailed = !file.delete();
            if (deleteFailed) {
                this.logger.warn("Failed to delete properties file with sensitive data: " + propertyFilePath);
            }
        }
    }

    public void projectSkipped(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.projectSkipped(event);
        }
    }

    public void projectStarted(ExecutionEvent event) {
        MavenProject project = event.getProject();
        this.initModule(project);
        if (this.wrappedListener != null) {
            this.wrappedListener.projectStarted(event);
        }
    }

    public void projectSucceeded(ExecutionEvent event) {
        this.finalizeModule(event.getProject());
        if (this.wrappedListener != null) {
            this.wrappedListener.projectSucceeded(event);
        }
    }

    public void projectFailed(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.projectFailed(event);
        }
    }

    public void forkStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkStarted(event);
        }
    }

    public void forkSucceeded(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkSucceeded(event);
        }
    }

    public void forkFailed(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkFailed(event);
        }
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkedProjectStarted(event);
        }
    }

    public void forkedProjectSucceeded(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkedProjectSucceeded(event);
        }
    }

    public void forkedProjectFailed(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkedProjectFailed(event);
        }
    }

    public void mojoSkipped(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoSkipped(event);
        }
    }

    public void mojoStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoStarted(event);
        }
    }

    public void mojoSucceeded(ExecutionEvent event) {
        List<File> resultsFile;
        MavenProject project = event.getProject();
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info dependency extraction: Null project.");
            return;
        }
        if (!this.projectHasTestFailures && "maven-surefire-plugin".equals(event.getMojoExecution().getPlugin().getArtifactId()) && this.isTestsFailed(resultsFile = this.getSurefireResultsFile(project))) {
            this.projectHasTestFailures = true;
        }
        this.extractModuleDependencies(project);
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoSucceeded(event);
        }
    }

    private List<File> getSurefireResultsFile(MavenProject project) {
        String[] xmls;
        ArrayList<File> surefireReports = new ArrayList<File>();
        File surefireDirectory = new File(new File(project.getFile().getParentFile(), "target"), "surefire-reports");
        try {
            xmls = surefireDirectory.list((dir, name) -> name.endsWith("xml"));
        }
        catch (Exception e) {
            this.logger.error("Error occurred: " + e.getMessage() + " while retrieving surefire descriptors at: " + surefireDirectory.getAbsolutePath(), (Throwable)e);
            return new ArrayList<File>();
        }
        if (xmls != null) {
            for (String xml : xmls) {
                surefireReports.add(new File(surefireDirectory, xml));
            }
        }
        return surefireReports;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTestsFailed(List<File> surefireReports) {
        Iterator<File> iterator = surefireReports.iterator();
        while (iterator.hasNext()) {
            File report = iterator.next();
            try {
                FileInputStream stream = new FileInputStream(report);
                Throwable throwable = null;
                try {
                    Document doc = this.getDocumentBuilder().parse(new InputSource(stream));
                    Boolean evaluate = (Boolean)this.xPathExpression.get().evaluate(doc, XPathConstants.BOOLEAN);
                    if (evaluate == null || !evaluate.booleanValue()) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (FileNotFoundException e) {
                this.logger.error("File '" + report.getAbsolutePath() + "' does not exist.", (Throwable)e);
            }
            catch (XPathExpressionException e) {
                this.logger.error("Expression '/testsuite/@failures>0 or /testsuite/@errors>0' is invalid.", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error("Expression caught while checking build tests result.", (Throwable)e);
            }
        }
        return false;
    }

    public void mojoFailed(ExecutionEvent event) {
        MavenProject project = event.getProject();
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info dependency extraction: Null project.");
            return;
        }
        this.extractModuleDependencies(project);
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoFailed(event);
        }
    }

    private void initModule(MavenProject project) {
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info module initialization: Null project.");
            return;
        }
        ModuleBuilder module = new ModuleBuilder().type(ModuleType.MAVEN);
        module.id(BuildInfoExtractorUtils.getModuleIdString((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion()));
        module.properties(project.getProperties());
        this.currentModule.set(module);
        this.currentModuleArtifacts.set(Collections.synchronizedSet(new HashSet()));
        this.currentModuleDependencies.set(Collections.synchronizedSet(new HashSet()));
    }

    private void extractArtifactsAndDependencies(MavenProject project) {
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info artifact and dependency extraction: Null project.");
            return;
        }
        Set<org.apache.maven.artifact.Artifact> artifacts = this.currentModuleArtifacts.get();
        if (artifacts == null) {
            this.logger.warn("Skipping Artifactory Build-Info project artifact extraction: Null current module artifacts.");
        } else {
            this.extractModuleArtifact(project, artifacts);
            this.extractModuleAttachedArtifacts(project, artifacts);
        }
        this.extractModuleDependencies(project);
    }

    private void finalizeModule(MavenProject project) {
        try {
            this.extractArtifactsAndDependencies(project);
            ModuleBuilder module = this.currentModule.get();
            if (module == null) {
                this.logger.warn("Skipping Artifactory Build-Info module finalization: Null current module.");
                return;
            }
            this.addModuleToBuild(project, module);
        }
        finally {
            this.cleanUpModule();
        }
    }

    private void extractModuleArtifact(MavenProject project, Set<org.apache.maven.artifact.Artifact> artifacts) {
        org.apache.maven.artifact.Artifact artifact = project.getArtifact();
        if (artifact == null) {
            this.logger.warn("Skipping Artifactory Build-Info project artifact extraction: Null artifact.");
            return;
        }
        artifacts.add(artifact);
    }

    private void extractModuleAttachedArtifacts(MavenProject project, Set<org.apache.maven.artifact.Artifact> artifacts) {
        List attachedArtifacts = project.getAttachedArtifacts();
        if (attachedArtifacts != null) {
            artifacts.addAll(attachedArtifacts);
        }
    }

    private void extractModuleDependencies(MavenProject project) {
        Set<org.apache.maven.artifact.Artifact> moduleDependencies = this.currentModuleDependencies.get();
        if (moduleDependencies == null) {
            this.logger.warn("Skipping Artifactory Build-Info project dependency extraction: Null current module dependencies.");
            return;
        }
        this.mergeProjectDependencies(project.getArtifacts());
    }

    private void mergeProjectDependencies(Set<org.apache.maven.artifact.Artifact> projectDependencies) {
        HashSet<DefaultArtifact> dependecies = new HashSet<DefaultArtifact>();
        for (org.apache.maven.artifact.Artifact artifact : projectDependencies) {
            String classifier = artifact.getClassifier();
            classifier = classifier == null ? "" : classifier;
            String scope = artifact.getScope();
            scope = StringUtils.isBlank((CharSequence)scope) ? "compile" : scope;
            DefaultArtifact art = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), scope, artifact.getType(), classifier, artifact.getArtifactHandler());
            art.setFile(artifact.getFile());
            dependecies.add(art);
        }
        Set<org.apache.maven.artifact.Artifact> moduleDependencies = this.currentModuleDependencies.get();
        HashSet<org.apache.maven.artifact.Artifact> tempSet = new HashSet<org.apache.maven.artifact.Artifact>(moduleDependencies);
        moduleDependencies.clear();
        moduleDependencies.addAll(dependecies);
        moduleDependencies.addAll(tempSet);
        if (this.conf.publisher.isRecordAllDependencies()) {
            moduleDependencies.addAll(this.resolvedArtifacts);
        }
    }

    private void addModuleToBuild(MavenProject project, ModuleBuilder module) {
        this.addArtifactsToCurrentModule(project, module);
        this.addDependenciesToCurrentModule(module);
        this.setModuleRepo(module);
        this.buildInfoBuilder.addModule(module.build());
    }

    private void addArtifactsToCurrentModule(MavenProject project, ModuleBuilder module) {
        ArtifactoryClientConfiguration.addDefaultPublisherAttributes((ArtifactoryClientConfiguration)this.conf, (String)project.getName(), (String)"Maven", (String)project.getVersion());
        if (!this.conf.publisher.shouldAddDeployableArtifacts().booleanValue()) {
            this.logger.info("Artifact metadata not requested - skipping artifact collection for build info");
            return;
        }
        Set<org.apache.maven.artifact.Artifact> moduleArtifacts = this.currentModuleArtifacts.get();
        if (moduleArtifacts == null) {
            this.logger.warn("Skipping Artifactory Build-Info module artifact addition: Null current module artifact list.");
            return;
        }
        ArtifactoryClientConfiguration.PublisherHandler publisher = this.conf.publisher;
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns());
        boolean excludeArtifactsFromBuild = publisher.isFilterExcludedArtifactsFromBuild();
        boolean pomFileAdded = false;
        for (org.apache.maven.artifact.Artifact moduleArtifact : moduleArtifacts) {
            String groupId = moduleArtifact.getGroupId();
            String artifactId = moduleArtifact.getArtifactId();
            String artifactVersion = moduleArtifact.getVersion();
            String artifactClassifier = moduleArtifact.getClassifier();
            String artifactExtension = moduleArtifact.getArtifactHandler().getExtension();
            String type = BuildInfoExtractorUtils.getTypeString((String)moduleArtifact.getType(), (String)artifactClassifier, (String)artifactExtension);
            File artifactFile = moduleArtifact.getFile();
            if ("pom".equals(type)) {
                pomFileAdded = true;
                if (moduleArtifact.equals(project.getArtifact())) {
                    artifactFile = project.getFile();
                }
            }
            if (artifactFile == null || !artifactFile.isFile()) continue;
            String artifactName = this.getArtifactName(artifactId, artifactVersion, artifactClassifier, artifactExtension);
            Artifact artifact = new ArtifactBuilder(artifactName).remotePath(this.getRemotePath(groupId, artifactId, artifactVersion)).type(type).build();
            String deploymentPath = this.getDeploymentPath(groupId, artifactId, artifactVersion, artifactClassifier, artifactExtension);
            boolean pathConflicts = PatternMatcher.pathConflicts((String)deploymentPath, (IncludeExcludePatterns)patterns);
            this.addArtifactToBuildInfo(artifact, pathConflicts, excludeArtifactsFromBuild, module);
            if (!this.conf.publisher.shouldAddDeployableArtifacts().booleanValue()) continue;
            this.addDeployableArtifact(artifact, artifactFile, pathConflicts, groupId, artifactId, artifactVersion, artifactClassifier, artifactExtension);
        }
        if (!pomFileAdded) {
            this.addPomArtifactIfExist(project, module, patterns, excludeArtifactsFromBuild);
        }
    }

    private void addPomArtifactIfExist(MavenProject project, ModuleBuilder module, IncludeExcludePatterns patterns, boolean excludeArtifactsFromBuild) {
        File pomFile = project.getFile();
        if (pomFile == null || !pomFile.exists()) {
            return;
        }
        org.apache.maven.artifact.Artifact projectArtifact = project.getArtifact();
        String artifactName = this.getArtifactName(projectArtifact.getArtifactId(), projectArtifact.getBaseVersion(), projectArtifact.getClassifier(), "pom");
        Artifact pomArtifact = new ArtifactBuilder(artifactName).remotePath(this.getRemotePath(projectArtifact.getGroupId(), projectArtifact.getArtifactId(), projectArtifact.getBaseVersion())).type("pom").build();
        String deploymentPath = this.getDeploymentPath(projectArtifact.getGroupId(), projectArtifact.getArtifactId(), projectArtifact.getVersion(), projectArtifact.getClassifier(), "pom");
        boolean pathConflicts = PatternMatcher.pathConflicts((String)deploymentPath, (IncludeExcludePatterns)patterns);
        this.addArtifactToBuildInfo(pomArtifact, pathConflicts, excludeArtifactsFromBuild, module);
        if (this.conf.publisher.shouldAddDeployableArtifacts().booleanValue()) {
            this.addDeployableArtifact(pomArtifact, pomFile, pathConflicts, projectArtifact.getGroupId(), projectArtifact.getArtifactId(), projectArtifact.getVersion(), projectArtifact.getClassifier(), "pom");
        }
    }

    private void addArtifactToBuildInfo(Artifact artifact, boolean pathConflicts, boolean isFilterExcludedArtifactsFromBuild, ModuleBuilder module) {
        if (isFilterExcludedArtifactsFromBuild && pathConflicts) {
            module.addExcludedArtifact(artifact);
        } else {
            module.addArtifact(artifact);
        }
    }

    private String getArtifactName(String artifactId, String version, String classifier, String fileExtension) {
        StringBuilder nameBuilder = new StringBuilder(artifactId).append("-").append(version);
        if (StringUtils.isNotBlank((CharSequence)classifier)) {
            nameBuilder.append("-").append(classifier);
        }
        return nameBuilder.append(".").append(fileExtension).toString();
    }

    private void addDeployableArtifact(Artifact artifact, File artifactFile, boolean pathConflicts, String groupId, String artifactId, String version, String classifier, String fileExtension) {
        if (pathConflicts) {
            this.logger.info("'" + artifact.getName() + "' will not be deployed due to the defined include-exclude patterns.");
            return;
        }
        String deploymentPath = this.getDeploymentPath(groupId, artifactId, version, classifier, fileExtension);
        String targetRepository = this.getTargetRepository(deploymentPath);
        DeployDetails deployable = new DeployDetails.Builder().artifactPath(deploymentPath).file(artifactFile).targetRepository(targetRepository).addProperties(this.conf.publisher.getMatrixParams()).packageType(DeployDetails.PackageType.MAVEN).build();
        String myArtifactId = BuildInfoExtractorUtils.getArtifactId((String)this.currentModule.get().build().getId(), (String)artifact.getName());
        this.deployableArtifactBuilderMap.put(myArtifactId, deployable);
    }

    public String getTargetRepository(String deployPath) {
        String snapshotsRepository = this.conf.publisher.getSnapshotRepoKey();
        if (snapshotsRepository != null && deployPath.contains("-SNAPSHOT")) {
            return snapshotsRepository;
        }
        return this.conf.publisher.getRepoKey();
    }

    private String getRemotePath(String groupId, String artifactId, String version) {
        return groupId.replace(".", "/") + "/" + artifactId + "/" + version;
    }

    private String getDeploymentPath(String groupId, String artifactId, String version, String classifier, String fileExtension) {
        return this.getRemotePath(groupId, artifactId, version) + "/" + this.getArtifactName(artifactId, version, classifier, fileExtension);
    }

    private void addDependenciesToCurrentModule(ModuleBuilder module) {
        Set<org.apache.maven.artifact.Artifact> moduleDependencies = this.currentModuleDependencies.get();
        if (moduleDependencies == null) {
            this.logger.warn("Skipping Artifactory Build-Info module dependency addition: Null current module dependency list.");
            return;
        }
        for (org.apache.maven.artifact.Artifact dependency : moduleDependencies) {
            File depFile = dependency.getFile();
            String gav = BuildInfoExtractorUtils.getModuleIdString((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion());
            DependencyBuilder dependencyBuilder = new DependencyBuilder().id(gav).requestedBy(this.dependencyParentsMaps.get(gav)).type(BuildInfoExtractorUtils.getTypeString((String)dependency.getType(), (String)dependency.getClassifier(), (String)this.getExtension(depFile)));
            String scopes = dependency.getScope();
            if (StringUtils.isNotBlank((CharSequence)scopes)) {
                dependencyBuilder.scopes((Set)CommonUtils.newHashSet((Object[])new String[]{scopes}));
            }
            this.setDependencyChecksums(depFile, dependencyBuilder);
            module.addDependency(dependencyBuilder.build());
        }
    }

    private String getExtension(File depFile) {
        int lastDot;
        String fileName;
        String extension = "";
        if (depFile != null && (fileName = depFile.getName()) != null && (lastDot = fileName.lastIndexOf(46)) > 0 && lastDot + 1 < fileName.length()) {
            extension = fileName.substring(lastDot + 1);
        }
        return extension;
    }

    private void setDependencyChecksums(File dependencyFile, DependencyBuilder dependencyBuilder) {
        if (dependencyFile != null && dependencyFile.isFile()) {
            try {
                Map checksumsMap = FileChecksumCalculator.calculateChecksums((File)dependencyFile, (String[])new String[]{"MD5", "SHA1", "SHA-256"});
                dependencyBuilder.md5((String)checksumsMap.get("MD5"));
                dependencyBuilder.sha1((String)checksumsMap.get("SHA1"));
                dependencyBuilder.sha256((String)checksumsMap.get("SHA-256"));
            }
            catch (IOException | NoSuchAlgorithmException e) {
                this.logger.error("Could not set checksum values on '" + dependencyBuilder.build().getId() + "': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setModuleRepo(ModuleBuilder module) {
        String repo = this.deployableArtifactBuilderMap.values().stream().map(DeployDetails::getTargetRepository).filter(StringUtils::isNotBlank).findAny().orElse("");
        module.repository(repo);
    }

    public BuildInfo extract(ExecutionEvent event) {
        MavenSession session = event.getSession();
        if (!session.getResult().hasExceptions()) {
            Date finish = new Date();
            long time = finish.getTime() - session.getRequest().getStartTime().getTime();
            BuildInfo buildInfo = this.buildInfoBuilder.durationMillis(time).build();
            PackageManagerUtils.collectEnvAndFilterProperties((ArtifactoryClientConfiguration)this.conf, (BuildInfo)buildInfo);
            return buildInfo;
        }
        return null;
    }

    public ResolutionHelper getResolutionHelper() {
        return this.resolutionHelper;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.documentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.documentBuilder = factory.newDocumentBuilder();
        }
        return this.documentBuilder;
    }

    private void cleanUpModule() {
        this.currentModule.remove();
        this.currentModuleArtifacts.remove();
        this.currentModuleDependencies.remove();
        this.resolvedArtifacts.clear();
    }

    private void setDeploymentPolicy(ExecutionEvent event) {
        List goals = event.getSession().getRequest().getGoals();
        if (goals.contains("deploy")) {
            event.getSession().getUserProperties().put("maven.deploy.skip", Boolean.TRUE.toString());
            return;
        }
        if (!goals.contains("install")) {
            this.conf.publisher.setPublishArtifacts(Boolean.valueOf(false));
            this.conf.publisher.setPublishBuildInfo(Boolean.valueOf(false));
            this.conf.publisher.setLegacyBooleanValue("artifacts", Boolean.valueOf(false));
            this.conf.publisher.setLegacyBooleanValue("buildInfo", Boolean.valueOf(false));
        }
    }
}

