/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jfrog.build.extractor.ProxySelector;
import org.jfrog.build.extractor.maven.resolver.ArtifactoryResolutionRepositoryBase;

public class ArtifactoryResolution
extends ArtifactoryResolutionRepositoryBase {
    private boolean isSnapshotEnabled = true;
    private String snapshotUpdatePolicy = "daily";

    public ArtifactoryResolution(String repoReleaseUrl, String snapshotRepoUrl, String repoUsername, String repoPassword, ProxySelector proxySelector, Logger logger) {
        super(repoReleaseUrl, snapshotRepoUrl, repoUsername, repoPassword, proxySelector, logger);
    }

    public RemoteRepository createSnapshotRepository() {
        if (super.shouldCreateSnapshotRepository()) {
            return this.createRepository(this.snapshotRepoUrl, "artifactory-snapshot", false, this.isSnapshotEnabled, this.snapshotUpdatePolicy);
        }
        return null;
    }

    public RemoteRepository createReleaseRepository() {
        if (this.shouldCreateReleaseRepository()) {
            String repositoryId = this.snapshotPolicyEnabled() ? "artifactory-release-snapshot" : "artifactory-release";
            return this.createRepository(this.releaseRepoUrl, repositoryId, true, this.snapshotPolicyEnabled(), this.snapshotUpdatePolicy);
        }
        return null;
    }

    public ArtifactoryResolution setSnapshotEnabled(boolean isSnapshotEnabled) {
        this.isSnapshotEnabled = isSnapshotEnabled;
        return this;
    }

    public ArtifactoryResolution setSnapshotUpdatePolicy(String snapshotUpdatePolicy) {
        this.snapshotUpdatePolicy = snapshotUpdatePolicy;
        return this;
    }

    private RemoteRepository createRepository(String repoUrl, String repoId, boolean releasePolicy, Boolean snapshotPolicy, String snapshotUpdatePolicy) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repoId, "default", repoUrl);
        this.setAuthentication(builder);
        this.setProxy(builder, repoUrl);
        this.setPolicy(builder, releasePolicy, snapshotPolicy, snapshotUpdatePolicy);
        return builder.build();
    }

    private void setAuthentication(RemoteRepository.Builder builder) {
        if (this.shouldSetAuthentication()) {
            Authentication authentication = new AuthenticationBuilder().addString("username", this.repoUsername).addSecret("password", this.repoPassword).build();
            builder.setAuthentication(authentication);
        }
    }

    private void setPolicy(RemoteRepository.Builder builder, boolean releasePolicyEnabled, boolean snapshotPolicyEnabled, String snapshotUpdatePolicy) {
        RepositoryPolicy releasePolicy = new RepositoryPolicy(releasePolicyEnabled, "daily", "warn");
        builder.setReleasePolicy(releasePolicy);
        RepositoryPolicy snapshotPolicy = new RepositoryPolicy(snapshotPolicyEnabled, snapshotUpdatePolicy, "warn");
        builder.setSnapshotPolicy(snapshotPolicy);
    }

    private void setProxy(RemoteRepository.Builder builder, String repoUrl) {
        Proxy proxy = this.createEclipseProxy(repoUrl);
        if (proxy != null) {
            builder.setProxy(proxy);
        }
    }
}

