/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.util;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ivy.core.IvyPatternHelper;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;

public class IvyResolverHelper {
    public static String calculateArtifactPath(ArtifactoryClientConfiguration.PublisherHandler publisher, Map<String, String> attributes, Map<String, String> extraAttributes) {
        String organization = attributes.get("organisation");
        String revision = attributes.get("revision");
        String moduleName = attributes.get("module");
        String ext = attributes.get("ext");
        String branch = attributes.get("branch");
        String type = attributes.get("type");
        String artifactPattern = IvyResolverHelper.getPattern(publisher, type);
        if (publisher.isM2Compatible()) {
            organization = organization.replace(".", "/");
        }
        return IvyPatternHelper.substitute((String)artifactPattern, (String)organization, (String)moduleName, (String)branch, (String)revision, (String)attributes.get("artifact"), (String)type, (String)ext, (String)attributes.get("conf"), null, extraAttributes, null);
    }

    private static String getPattern(ArtifactoryClientConfiguration.PublisherHandler pub, String type) {
        if (IvyResolverHelper.isIvy(type)) {
            return pub.getIvyPattern();
        }
        return pub.getIvyArtifactPattern();
    }

    private static boolean isIvy(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return false;
        }
        return "ivy".equals(type);
    }
}

