/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.compress.utils.Sets;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ModuleExtractor;
import org.jfrog.build.extractor.builder.ArtifactBuilder;
import org.jfrog.build.extractor.builder.DependencyBuilder;
import org.jfrog.build.extractor.builder.ModuleBuilder;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPlugin;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.ProjectUtils;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.extractor.listener.ArtifactoryDependencyResolutionListener;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;

public class GradleModuleExtractor
implements ModuleExtractor<Project> {
    private static final Logger log = Logging.getLogger(GradleModuleExtractor.class);

    public Module extractModule(Project project) {
        Set<Object> gradleDeployDetails = new HashSet();
        String artifactName = project.getName();
        ArtifactoryTask artifactoryTask = ProjectUtils.getBuildInfoTask(project);
        if (artifactoryTask != null) {
            artifactName = project.getName();
            try {
                artifactoryTask.collectDescriptorsAndArtifactsForUpload();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot collect deploy details for " + artifactoryTask.getPath(), e);
            }
            gradleDeployDetails = artifactoryTask.deployDetails;
        }
        String repo = gradleDeployDetails.stream().map(GradleDeployDetails::getDeployDetails).map(DeployDetails::getTargetRepository).findAny().orElse("");
        String moduleId = BuildInfoExtractorUtils.getModuleIdString((String)project.getGroup().toString(), (String)artifactName, (String)project.getVersion().toString());
        ModuleBuilder builder = new ModuleBuilder().type(ModuleType.GRADLE).id(moduleId).repository(repo);
        try {
            ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(project);
            if (publisher != null) {
                Iterable<GradleDeployDetails> deployExcludeDetails;
                Iterable deployIncludeDetails;
                boolean excludeArtifactsFromBuild = publisher.isFilterExcludedArtifactsFromBuild();
                IncludeExcludePatterns patterns = new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns());
                if (excludeArtifactsFromBuild) {
                    deployIncludeDetails = gradleDeployDetails.stream().filter(new IncludeExcludePredicate(project, patterns, true)).collect(Collectors.toSet());
                    deployExcludeDetails = gradleDeployDetails.stream().filter(new IncludeExcludePredicate(project, patterns, false)).collect(Collectors.toSet());
                } else {
                    deployIncludeDetails = gradleDeployDetails.stream().filter(new ProjectPredicate(project)).collect(Collectors.toSet());
                    deployExcludeDetails = new ArrayList<GradleDeployDetails>();
                }
                builder.artifacts(this.calculateArtifacts(deployIncludeDetails)).excludedArtifacts(this.calculateArtifacts(deployExcludeDetails));
            } else {
                log.warn("No publisher config found for project: " + project.getName());
            }
            builder.dependencies(this.calculateDependencies(project, moduleId));
        }
        catch (Exception e) {
            log.error("Error during extraction: ", (Throwable)e);
        }
        return builder.build();
    }

    private List<Artifact> calculateArtifacts(Iterable<GradleDeployDetails> deployDetails) {
        return StreamSupport.stream(deployDetails.spliterator(), false).map(from -> {
            PublishArtifactInfo publishArtifact = from.getPublishArtifact();
            DeployDetails deployDetails1 = from.getDeployDetails();
            String artifactPath = deployDetails1.getArtifactPath();
            int index = artifactPath.lastIndexOf(47);
            return new ArtifactBuilder(artifactPath.substring(index + 1)).type(BuildInfoExtractorUtils.getTypeString((String)publishArtifact.getType(), (String)publishArtifact.getClassifier(), (String)publishArtifact.getExtension())).md5(deployDetails1.getMd5()).sha1(deployDetails1.getSha1()).sha256(deployDetails1.getSha256()).remotePath(artifactPath).build();
        }).collect(Collectors.toList());
    }

    private List<Dependency> calculateDependencies(Project project, String moduleId) throws Exception {
        ArtifactoryDependencyResolutionListener artifactoryDependencyResolutionListener = ((ArtifactoryPlugin)project.getRootProject().getPlugins().getPlugin(ArtifactoryPlugin.class)).getArtifactoryDependencyResolutionListener();
        Map<String, String[][]> requestedByMap = artifactoryDependencyResolutionListener.getModulesHierarchyMap().get(moduleId);
        ConfigurationContainer configurationSet = project.getConfigurations();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Configuration configuration : configurationSet) {
            Set resolvedArtifactSet;
            if (!configuration.isCanBeResolved()) {
                log.debug("Configuration '{}' is not resolvable, skipping.", (Object)configuration.getName());
                continue;
            }
            if (configuration.getState() != Configuration.State.RESOLVED) {
                log.info("Artifacts for configuration '{}' were not all resolved, skipping", (Object)configuration.getName());
                continue;
            }
            ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
            try {
                log.debug("Attempting to resolve artifacts for configuration: " + configuration.getName());
                resolvedArtifactSet = resolvedConfiguration.getResolvedArtifacts();
                log.debug("Successfully resolved {} artifacts for configuration: {}", (Object)resolvedArtifactSet.size(), (Object)configuration.getName());
            }
            catch (Exception e) {
                log.warn("Failed to resolve artifacts for configuration '{}', skipping: {}", (Object)configuration.getName(), (Object)e.getMessage());
                continue;
            }
            for (ResolvedArtifact artifact : resolvedArtifactSet) {
                File file = artifact.getFile();
                if (!file.exists()) continue;
                ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
                String depId = BuildInfoExtractorUtils.getModuleIdString((String)id.getGroup(), (String)id.getName(), (String)id.getVersion());
                Dependency existingDependency = dependencies.stream().filter(input -> input.getId().equals(depId)).findAny().orElse(null);
                if (existingDependency != null) {
                    Set existingScopes = existingDependency.getScopes();
                    existingScopes.add(configuration.getName());
                    existingDependency.setScopes(existingScopes);
                    continue;
                }
                DependencyBuilder dependencyBuilder = new DependencyBuilder().type(BuildInfoExtractorUtils.getTypeString((String)artifact.getType(), (String)artifact.getClassifier(), (String)artifact.getExtension())).id(depId).scopes((Set)Sets.newHashSet((Object[])new String[]{configuration.getName()}));
                if (requestedByMap != null) {
                    dependencyBuilder.requestedBy(requestedByMap.get(depId));
                }
                if (file.isFile()) {
                    Map checksums = FileChecksumCalculator.calculateChecksums((File)file, (String[])new String[]{"MD5", "SHA1", "SHA-256"});
                    dependencyBuilder.md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1")).sha256((String)checksums.get("SHA-256"));
                }
                dependencies.add(dependencyBuilder.build());
            }
        }
        return dependencies;
    }

    private static class IncludeExcludePredicate
    implements Predicate<GradleDeployDetails> {
        private final Project project;
        private final IncludeExcludePatterns patterns;
        private final boolean include;

        public IncludeExcludePredicate(Project project, IncludeExcludePatterns patterns, boolean include) {
            this.project = project;
            this.patterns = patterns;
            this.include = include;
        }

        @Override
        public boolean test(@Nullable GradleDeployDetails input) {
            if (input == null) {
                return false;
            }
            if (this.include) {
                return input.getProject().equals(this.project) && !PatternMatcher.pathConflicts((String)input.getDeployDetails().getArtifactPath(), (IncludeExcludePatterns)this.patterns);
            }
            return input.getProject().equals(this.project) && PatternMatcher.pathConflicts((String)input.getDeployDetails().getArtifactPath(), (IncludeExcludePatterns)this.patterns);
        }
    }

    private static class ProjectPredicate
    implements Predicate<GradleDeployDetails> {
        private final Project project;

        private ProjectPredicate(Project project) {
            this.project = project;
        }

        @Override
        public boolean test(@Nullable GradleDeployDetails input) {
            if (input == null) {
                return false;
            }
            return input.getProject().equals(this.project);
        }
    }
}

