/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.tasks;

import com.jfrog.GradleDepTreeResults;
import com.jfrog.GradleDependencyNode;
import com.jfrog.GradleDependencyTreeUtils;
import com.jfrog.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;

@CacheableTask
public class GenerateDepTrees
extends DefaultTask {
    public static final String OUTPUT_FILE_PROPERTY = "com.jfrog.depsTreeOutputFile";
    public static final String TASK_NAME = "generateDepTrees";
    public static final String INCLUDE_ALL_BUILD_FILES = "com.jfrog.includeAllBuildFiles";
    public static final String CURATION_AUDIT_MODE = "com.jfrog.curationAuditMode";
    public static final String INCLUDE_INCLUDED_BUILDS = "com.jfrog.includeIncludedBuilds";
    private final Path pluginOutputDir = Paths.get(this.getProject().getRootProject().getBuildDir().getPath(), "gradle-dep-tree");

    public GenerateDepTrees() {
        this.setImpliesSubProjects(true);
        this.setOnlyIf(element -> {
            if (System.getProperty(OUTPUT_FILE_PROPERTY) == null) {
                throw new GradleException("'com.jfrog.depsTreeOutputFile' system property is mandatory");
            }
            return true;
        });
        List gradleVersionParts = Arrays.stream(this.getProject().getGradle().getGradleVersion().split("\\.")).map(Integer::valueOf).collect(Collectors.toList());
        if ((Integer)gradleVersionParts.get(0) >= 8 || (Integer)gradleVersionParts.get(0) == 7 && (Integer)gradleVersionParts.get(1) >= 4) {
            this.notCompatibleWithConfigurationCache("Accesses projects at execution time");
        }
    }

    @Inject
    public BuildStateRegistry getBuildStateRegistry() {
        throw new UnsupportedOperationException();
    }

    @Internal
    @Nonnull
    public String getName() {
        return TASK_NAME;
    }

    @InputFiles
    @Classpath
    public List<File> getInputFile() {
        ArrayList<File> inputFiles = new ArrayList<File>();
        for (Project project = this.getProject(); project != null; project = project.getParent()) {
            inputFiles.add(project.getBuildFile());
        }
        return inputFiles;
    }

    @OutputFiles
    public List<File> getOutputFiles() {
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (Project project : this.getRelatedProjects()) {
            outputFiles.add(this.getProjectOutputFile(project));
        }
        return outputFiles;
    }

    @TaskAction
    void generateDepTrees() throws IOException {
        this.createOutputDir();
        for (Project project : this.getRelatedProjects()) {
            GradleDepTreeResults results = this.createProjectDependencyTree(project);
            Utils.saveToFileAsJson(this.getProjectOutputFile(project), results);
        }
    }

    @Internal
    @Nonnull
    public TaskDependency getFinalizedBy() {
        String outputFile = System.getProperty(OUTPUT_FILE_PROPERTY);
        try (FileWriter writer = new FileWriter(outputFile, false);){
            for (File file : this.getOutputFiles()) {
                writer.append(file.getAbsolutePath()).append(System.lineSeparator());
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new GradleException("File '" + outputFile + "' is not writable", (Throwable)e);
        }
        return super.getFinalizedBy();
    }

    private List<Project> getRelatedProjects() {
        HashMap<String, Project> projectsMap = new HashMap<String, Project>();
        Project rootProj = this.getProject();
        projectsMap.put(rootProj.getPath(), rootProj);
        boolean includeAllBuildFiles = Boolean.parseBoolean(System.getProperty(INCLUDE_ALL_BUILD_FILES));
        for (Project project : rootProj.getSubprojects()) {
            if (!includeAllBuildFiles && project.getBuildFile().exists()) continue;
            projectsMap.put(project.getPath(), project);
        }
        if (Boolean.parseBoolean(System.getProperty(INCLUDE_INCLUDED_BUILDS))) {
            try {
                for (IncludedBuildState b : this.getBuildStateRegistry().getIncludedBuilds()) {
                    for (ProjectState ps : b.getProjects().getAllProjects()) {
                        for (Project p : ps.getMutableModel().getAllprojects()) {
                            projectsMap.put(p.getPath(), p);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return new ArrayList<Project>(projectsMap.values());
    }

    private File getProjectOutputFile(Project project) {
        return project.file((Object)this.pluginOutputDir.resolve(Base64.getEncoder().encodeToString(project.getName().getBytes(StandardCharsets.UTF_8))));
    }

    private void createOutputDir() throws IOException {
        Files.createDirectories(this.pluginOutputDir, new FileAttribute[0]);
    }

    private GradleDepTreeResults createProjectDependencyTree(Project project) {
        String rootId = this.getProjectModuleId(project);
        GradleDependencyNode root = new GradleDependencyNode();
        HashMap<String, GradleDependencyNode> nodes = new HashMap<String, GradleDependencyNode>();
        nodes.put(rootId, root);
        ConfigurationContainer configsContainer = project.getConfigurations();
        HashSet names = new HashSet(configsContainer.getNames());
        for (String name : names) {
            GradleDependencyTreeUtils.addConfiguration(root, configsContainer.getByName(name), nodes);
        }
        return new GradleDepTreeResults(rootId, nodes);
    }

    private String getProjectModuleId(Project project) {
        String unspecifiedIdPart = "unspecified";
        String group = project.getGroup().toString().isEmpty() ? "unspecified" : project.getGroup().toString();
        String name = project.getName().isEmpty() ? "unspecified" : project.getName();
        String version = project.getVersion().toString().isEmpty() ? "unspecified" : project.getVersion().toString();
        return String.join((CharSequence)":", group, name, version);
    }
}

