/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.client.response.GetAllBuildNumbersResponse;
import org.jfrog.build.extractor.util.TestingLog;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class IntegrationTestsBase {
    protected static final Log log = new TestingLog();
    protected static final String LOCAL_REPO_PLACEHOLDER = "${LOCAL_REPO}";
    protected static final String LOCAL_REPO2_PLACEHOLDER = "${LOCAL_REPO2}";
    protected static final String VIRTUAL_REPO_PLACEHOLDER = "${VIRTUAL_REPO}";
    protected static final String TEMP_FOLDER_PLACEHOLDER = "${TEMP_FOLDER}";
    protected static final String LOCAL_REPOSITORIES_WILDCARD_PLACEHOLDER = "${LOCAL_REPO1_REPO2}";
    protected static final String UPLOAD_SPEC = "upload.json";
    protected static final String DOWNLOAD_SPEC = "download.json";
    protected static final String EXPECTED = "expected.json";
    protected static final String BITESTS_ENV_VAR_PREFIX = "BITESTS_PLATFORM_";
    private static final String BITESTS_PROPERTIES_PREFIX = "bitests.platform.";
    protected static final String BITESTS_ARTIFACTORY_ENV_VAR_PREFIX = "BITESTS_ARTIFACTORY_";
    protected String localRepo1 = IntegrationTestsBase.getKeyWithTimestamp("build-info-tests-local");
    protected String localRepo2 = IntegrationTestsBase.getKeyWithTimestamp("build-info-tests-local2");
    protected String remoteRepo;
    protected String virtualRepo = IntegrationTestsBase.getKeyWithTimestamp("build-info-tests-virtual");
    protected String localRepositoriesWildcard = "build-info-tests-local*";
    protected ArtifactoryManager artifactoryManager;
    protected ArtifactoryManagerBuilder artifactoryManagerBuilder;
    private String username;
    private String adminToken;
    private String platformUrl;
    private String artifactoryUrl;
    public static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile("^/(\\d+)$");
    public static final long CURRENT_TIME = System.currentTimeMillis();
    StringSubstitutor stringSubstitutor;

    public static Log getLog() {
        return log;
    }

    public void init(boolean isAccessTest) throws IOException {
        Properties props = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("/artifactory-bi.properties");
        if (inputStream != null) {
            props.load(inputStream);
            inputStream.close();
        }
        String testPort = "8081";
        if (isAccessTest) {
            testPort = "8082";
        }
        this.platformUrl = this.readParam(props, "url", "http://127.0.0.1:" + testPort);
        if (!this.platformUrl.endsWith("/")) {
            this.platformUrl = this.platformUrl + "/";
        }
        this.artifactoryUrl = this.platformUrl + "artifactory/";
        this.username = this.readParam(props, "username", "admin");
        this.adminToken = this.readParam(props, "admin_token", "password");
        this.artifactoryManager = this.createArtifactoryManager();
        this.artifactoryManagerBuilder = this.createArtifactoryManagerBuilder();
        this.createStringSubstitutor();
        if (StringUtils.isNotEmpty((CharSequence)this.localRepo1)) {
            this.createTestRepo(this.localRepo1);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.remoteRepo)) {
            this.createTestRepo(this.remoteRepo);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.virtualRepo)) {
            this.createTestRepo(this.virtualRepo);
        }
    }

    @BeforeClass
    public void init() throws IOException {
        this.init(false);
    }

    @BeforeClass
    public void accessInit() throws IOException {
        this.init(true);
    }

    @AfterClass
    protected void terminate() throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)this.virtualRepo)) {
            this.deleteTestRepo(this.virtualRepo);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.remoteRepo)) {
            this.deleteTestRepo(this.remoteRepo);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.localRepo1)) {
            this.deleteTestRepo(this.localRepo1);
        }
        this.artifactoryManager.close();
    }

    private void createStringSubstitutor() {
        HashMap<String, String> textParameters = new HashMap<String, String>();
        textParameters.put("LOCAL_REPO_1", this.localRepo1);
        textParameters.put("REMOTE_REPO", this.remoteRepo);
        this.stringSubstitutor = new StringSubstitutor(textParameters);
    }

    protected String readParam(Properties props, String paramName, String defaultValue) {
        String paramValue = null;
        if (!props.isEmpty()) {
            paramValue = props.getProperty(BITESTS_PROPERTIES_PREFIX + paramName);
        }
        if (StringUtils.isBlank(paramValue)) {
            paramValue = System.getProperty(BITESTS_PROPERTIES_PREFIX + paramName);
        }
        if (StringUtils.isBlank(paramValue)) {
            paramValue = System.getenv(BITESTS_ENV_VAR_PREFIX + paramName.toUpperCase());
        }
        if (StringUtils.isBlank(paramValue)) {
            paramValue = defaultValue;
        }
        return paramValue;
    }

    protected void deleteContentFromRepo(String repoKey) throws IOException {
        if (!this.artifactoryManager.isRepositoryExist(repoKey)) {
            return;
        }
        this.artifactoryManager.deleteRepositoryContent(repoKey);
    }

    protected void createTestRepo(String repoKey) throws IOException {
        if (this.artifactoryManager.isRepositoryExist(repoKey)) {
            return;
        }
        String path = "/integration/settings/" + StringUtils.substringBeforeLast((String)repoKey, (String)"-") + ".json";
        try (InputStream repoConfigInputStream = this.getClass().getResourceAsStream(path);){
            if (repoConfigInputStream == null) {
                throw new IOException("Couldn't find repository settings in " + path);
            }
            String json = IOUtils.toString((InputStream)repoConfigInputStream, (String)StandardCharsets.UTF_8.name());
            this.artifactoryManager.createRepository(repoKey, this.stringSubstitutor.replace(json));
        }
    }

    protected void deleteTestRepo(String repo) throws IOException {
        this.artifactoryManager.deleteRepository(repo);
    }

    protected String readSpec(File specFile, String workSpacePath) throws IOException {
        String spec = FileUtils.readFileToString((File)specFile, (Charset)StandardCharsets.UTF_8);
        spec = StringUtils.replace((String)spec, (String)LOCAL_REPO_PLACEHOLDER, (String)this.localRepo1);
        spec = StringUtils.replace((String)spec, (String)LOCAL_REPO2_PLACEHOLDER, (String)this.localRepo2);
        spec = StringUtils.replace((String)spec, (String)VIRTUAL_REPO_PLACEHOLDER, (String)this.virtualRepo);
        spec = StringUtils.replace((String)spec, (String)TEMP_FOLDER_PLACEHOLDER, (String)workSpacePath);
        spec = StringUtils.replace((String)spec, (String)LOCAL_REPOSITORIES_WILDCARD_PLACEHOLDER, (String)this.localRepositoriesWildcard);
        return StringUtils.replace((String)spec, (String)"${WORKSPACE}", (String)workSpacePath);
    }

    protected static String getKeyWithTimestamp(String key) {
        return key + "-" + CURRENT_TIME;
    }

    protected void verifyExpected(Expected expected, File workspace) {
        Assert.assertTrue((boolean)workspace.exists(), (String)("The path: '" + workspace.getPath() + "' does not exist"));
        Collection downloadedFiles = FileUtils.listFiles((File)workspace, null, (boolean)true);
        for (String path : expected.getFiles()) {
            File f = new File(workspace, path);
            Assert.assertTrue((boolean)downloadedFiles.contains(f), (String)("Missing file: '" + path + "'."));
            downloadedFiles.remove(f);
        }
        for (File f : downloadedFiles) {
            Assert.fail((String)("Unexpected file: '" + f.getPath() + "'."));
        }
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getAdminToken() {
        return this.adminToken;
    }

    protected String getPlatformUrl() {
        return this.platformUrl;
    }

    protected String getArtifactoryUrl() {
        return this.artifactoryUrl;
    }

    private ArtifactoryManager createArtifactoryManager() {
        return new ArtifactoryManager(this.artifactoryUrl, this.username, this.adminToken, log);
    }

    private ArtifactoryManagerBuilder createArtifactoryManagerBuilder() {
        ArtifactoryManagerBuilder builder = new ArtifactoryManagerBuilder();
        return (ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)builder.setServerUrl(this.artifactoryUrl)).setUsername(this.username)).setPassword(this.adminToken)).setLog(log);
    }

    private static boolean isOldBuild(Matcher buildMatcher) {
        long repoTimestamp = Long.parseLong(buildMatcher.group(1));
        return TimeUnit.MILLISECONDS.toHours(CURRENT_TIME - repoTimestamp) >= 24L;
    }

    public void cleanTestBuilds(String buildName, String buildNumber, String project) throws IOException {
        this.artifactoryManager.deleteBuilds(buildName, project, true, new String[]{buildNumber});
        this.cleanOldBuilds(buildName, project);
    }

    private void cleanOldBuilds(String buildName, String project) throws IOException {
        String[] oldBuildNumbers = (String[])this.artifactoryManager.getAllBuildNumbers((String)buildName, (String)project).buildsNumbers.stream().map(GetAllBuildNumbersResponse.BuildsNumberDetails::getUri).distinct().map(BUILD_NUMBER_PATTERN::matcher).filter(Matcher::matches).filter(IntegrationTestsBase::isOldBuild).map(matcher -> matcher.group(1)).toArray(String[]::new);
        if (oldBuildNumbers.length > 0) {
            this.artifactoryManager.deleteBuilds(buildName, project, true, oldBuildNumbers);
        }
    }

    protected static class Expected {
        private List<String> files;

        protected Expected() {
        }

        public List<String> getFiles() {
            return this.files;
        }

        public void setFiles(List<String> files) {
            this.files = files;
        }
    }
}

