/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.pip;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.executor.CommandExecutor;
import org.jfrog.build.extractor.executor.CommandResults;

public class PipDriver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CommandExecutor commandExecutor;

    public PipDriver(String executablePath, Map<String, String> env) {
        this.commandExecutor = new CommandExecutor(executablePath, env);
    }

    public String install(File workingDirectory, String url, List<String> commandArgs, Log logger) throws IOException {
        try {
            ArrayList<String> finalArgs = new ArrayList<String>(Arrays.asList("install"));
            finalArgs.addAll(commandArgs);
            finalArgs.addAll(Arrays.asList("-i", url));
            return this.runCommand(workingDirectory, finalArgs, logger);
        }
        catch (IOException | InterruptedException e) {
            throw new IOException("pip install failed: " + e.getMessage(), e);
        }
    }

    public String freeze(File workingDirectory, Log logger) throws IOException {
        try {
            ArrayList<String> finalArgs = new ArrayList<String>(Arrays.asList("freeze", "--local"));
            return this.runCommand(workingDirectory, finalArgs, logger);
        }
        catch (IOException | InterruptedException e) {
            throw new IOException("pip freeze failed: " + e.getMessage(), e);
        }
    }

    public String runCommand(File workingDirectory, List<String> args, Log logger) throws IOException, InterruptedException {
        CommandResults pipCommandRes = this.commandExecutor.exeCommand(workingDirectory, args, null, logger);
        if (!pipCommandRes.isOk()) {
            throw new IOException(pipCommandRes.getErr() + pipCommandRes.getRes());
        }
        return pipCommandRes.getErr() + pipCommandRes.getRes();
    }
}

