/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.DefaultMetadataResolver;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.jfrog.build.extractor.maven.resolver.ArtifactoryEclipseResolversHelper;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;

@Named
@Component(role=ArtifactoryEclipseMetadataResolver.class)
public class ArtifactoryEclipseMetadataResolver
extends DefaultMetadataResolver {
    @Requirement
    private ResolutionHelper resolutionHelper;
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactoryEclipseResolversHelper helper;

    private void enforceResolutionRepositories(RepositorySystemSession session, MetadataRequest request) {
        List<RemoteRepository> repositories = this.helper.getResolutionRepositories(session);
        if (repositories != null && !repositories.isEmpty() && request.getRepository() != null && request.getMetadata() != null) {
            if (request.getMetadata().getNature() == Metadata.Nature.SNAPSHOT) {
                request.setRepository(this.getSnapshotRepository(session));
            } else {
                request.setRepository(this.getReleaseRepository(session));
            }
        }
    }

    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        for (MetadataRequest metadataRequest : requests) {
            this.enforceResolutionRepositories(session, metadataRequest);
        }
        return super.resolveMetadata(session, requests);
    }

    public RemoteRepository getSnapshotRepository(RepositorySystemSession session) {
        return this.helper.getSnapshotRepository(session);
    }

    public RemoteRepository getReleaseRepository(RepositorySystemSession session) {
        return this.helper.getReleaseRepository(session);
    }
}

