/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import java.io.File;
import java.io.IOException;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jfrog.build.extractor.ModuleExtractorUtils;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleModuleExtractor;

public class ExtractModuleTask
extends DefaultTask {
    private static final Logger log = Logging.getLogger(ExtractModuleTask.class);
    private final RegularFileProperty moduleFile = this.getProject().getObjects().fileProperty();

    @OutputFile
    public RegularFileProperty getModuleFile() {
        return this.moduleFile;
    }

    @TaskAction
    public void extractModule() {
        log.info("Extracting details for {}", (Object)this.getPath());
        Module module = new GradleModuleExtractor().extractModule(this.getProject());
        try {
            ModuleExtractorUtils.saveModuleToFile((Module)module, (File)((File)this.moduleFile.getAsFile().get()));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save module file", e);
        }
    }
}

