/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor.publication;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.apache.ivy.core.IvyPatternHelper;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.extractor.publication.PublicationExtractor;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.ExtensionsUtils;
import org.jfrog.gradle.plugin.artifactory.utils.PublicationUtils;

public class MavenPublicationExtractor
extends PublicationExtractor<MavenPublication> {
    public MavenPublicationExtractor(ArtifactoryTask artifactoryTask) {
        super(artifactoryTask);
    }

    @Override
    public void extractDeployDetails(MavenPublication publication) {
        this.extractMavenDescriptor(publication);
        this.extractMavenArtifacts(publication);
    }

    @Override
    protected void addArtifactToDeployDetails(MavenPublication publication, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo) {
        Map<String, String> extraTokens = artifactInfo.getExtraTokens();
        String artifactPath = IvyPatternHelper.substitute((String)"[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]", (String)publication.getGroupId().replace(".", "/"), (String)publication.getArtifactId(), (String)publication.getVersion(), (String)artifactInfo.getName(), (String)artifactInfo.getType(), (String)artifactInfo.getExtension(), (String)publication.getName(), extraTokens, null);
        builder.artifactPath(artifactPath);
        PublicationUtils.addArtifactInfoToDeployDetails(this.artifactoryTask, publication.getName(), builder, artifactInfo, artifactPath);
    }

    @Override
    protected String getPublicationArtifactId(MavenPublication publication) {
        return publication.getArtifactId();
    }

    @Override
    protected boolean isApplicablePublication(Publication publication) {
        return publication instanceof MavenPublication;
    }

    private void extractMavenDescriptor(MavenPublication publication) {
        if (!this.isPublishMaven()) {
            return;
        }
        GenerateMavenPom generateMavenPom = this.artifactoryTask.getProject().getTasks().withType(GenerateMavenPom.class).stream().filter(generateMavenPomCandidate -> Objects.equals(generateMavenPomCandidate.getPom(), publication.getPom())).findAny().orElse(null);
        if (generateMavenPom == null) {
            return;
        }
        File pomFile = generateMavenPom.getDestination();
        if (!pomFile.exists()) {
            return;
        }
        this.buildAndPublishArtifactWithSignatures(pomFile, publication, publication.getArtifactId(), "pom", "pom", null, null);
    }

    private boolean isPublishMaven() {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ExtensionsUtils.getPublisherHandler(this.artifactoryTask.getProject());
        if (publisher == null) {
            return false;
        }
        Boolean publishPom = publisher.isMaven();
        if (publishPom == null) {
            publishPom = this.artifactoryTask.getPublishPom();
        }
        return publishPom != null ? publishPom : true;
    }

    private void extractMavenArtifacts(MavenPublication publication) {
        for (MavenArtifact artifact : publication.getArtifacts()) {
            this.createPublishArtifactInfoAndAddToDeployDetails(artifact, publication);
        }
    }

    private void createPublishArtifactInfoAndAddToDeployDetails(MavenArtifact artifact, MavenPublication publication) {
        File file = artifact.getFile();
        this.buildAndPublishArtifactWithSignatures(file, publication, publication.getArtifactId(), artifact.getExtension(), artifact.getExtension(), artifact.getClassifier(), null);
    }
}

