/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.util.PathSanitizer;

public class GradleArtifactoryClientConfigUpdater {
    public static void update(ArtifactoryClientConfiguration config, Project project) {
        Properties fileProps;
        Properties props = new Properties();
        GradleArtifactoryClientConfigUpdater.fillProperties(project, props);
        StartParameter startParameter = project.getGradle().getStartParameter();
        Map startProps = startParameter.getProjectProperties();
        props.putAll((Map<?, ?>)BuildInfoExtractorUtils.filterStringEntries((Map)startProps));
        Properties mergedProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile((Properties)props, (Log)config.info.getLog());
        String buildInfoPropFile = System.getProperty("buildInfoConfig.propertiesFile");
        String propSource = "system property (buildInfoConfig.propertiesFile)";
        if (StringUtils.isBlank((CharSequence)buildInfoPropFile)) {
            buildInfoPropFile = System.getProperty("BUILDINFO_PROPFILE");
            propSource = "system property (BUILDINFO_PROPFILE)";
        }
        if (StringUtils.isNotBlank((CharSequence)buildInfoPropFile) && (fileProps = GradleArtifactoryClientConfigUpdater.loadBuildInfoProperties(buildInfoPropFile, config.info.getLog())) != null) {
            mergedProps.putAll((Map<?, ?>)fileProps);
            config.info.getLog().debug("Overriding with properties from " + propSource + ": " + buildInfoPropFile);
        }
        Properties buildInfoProperties = BuildInfoExtractorUtils.filterDynamicProperties((Properties)mergedProps, (Predicate)BuildInfoExtractorUtils.BUILD_INFO_PROP_PREDICATE);
        buildInfoProperties = BuildInfoExtractorUtils.stripPrefixFromProperties((Properties)buildInfoProperties, (String)"buildInfo.property.");
        mergedProps.putAll((Map<?, ?>)buildInfoProperties);
        String prefix = "buildInfo.";
        HashSet excludeIfExist = CommonUtils.newHashSet((Object[])new String[]{prefix + "build.number", prefix + "build.name", prefix + "build.started"});
        config.fillFromProperties(mergedProps, (Set)excludeIfExist);
        ArtifactoryClientConfiguration.addDefaultPublisherAttributes((ArtifactoryClientConfiguration)config, (String)project.getRootProject().getName(), (String)"Gradle", (String)project.getGradle().getGradleVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadBuildInfoProperties(String filePath, Log log) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return null;
        }
        File propertiesFile = PathSanitizer.validateAndNormalize((String)filePath);
        if (propertiesFile == null || !propertiesFile.exists()) {
            log.warn("Properties file not found at: " + filePath);
            return null;
        }
        try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
            Properties fileProps = new Properties();
            fileProps.load(inputStream);
            Properties properties = fileProps;
            return properties;
        }
        catch (Exception e) {
            log.error("Failed to load properties from: " + filePath + " - " + e.getMessage());
            return null;
        }
    }

    private static void fillProperties(Project project, Properties props) {
        Project parent = project.getParent();
        if (parent != null) {
            GradleArtifactoryClientConfigUpdater.fillProperties(parent, props);
        }
        Map projectProperties = project.getExtensions().getExtraProperties().getProperties();
        props.putAll((Map<?, ?>)BuildInfoExtractorUtils.filterStringEntries((Map)projectProperties));
    }
}

