/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;

public class GradleArtifactoryClientConfigUpdater {
    public static void update(ArtifactoryClientConfiguration config, Project project) {
        Properties props = new Properties();
        GradleArtifactoryClientConfigUpdater.fillProperties(project, props);
        StartParameter startParameter = project.getGradle().getStartParameter();
        Map startProps = startParameter.getProjectProperties();
        props.putAll((Map<?, ?>)BuildInfoExtractorUtils.filterStringEntries((Map)startProps));
        Properties mergedProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile((Properties)props, (Log)config.info.getLog());
        Properties buildInfoProperties = BuildInfoExtractorUtils.filterDynamicProperties((Properties)mergedProps, (Predicate)BuildInfoExtractorUtils.BUILD_INFO_PROP_PREDICATE);
        buildInfoProperties = BuildInfoExtractorUtils.stripPrefixFromProperties((Properties)buildInfoProperties, (String)"buildInfo.property.");
        mergedProps.putAll((Map<?, ?>)buildInfoProperties);
        String prefix = "buildInfo.";
        HashSet excludeIfExist = CommonUtils.newHashSet((Object[])new String[]{prefix + "build.number", prefix + "build.name", prefix + "build.started"});
        config.fillFromProperties(mergedProps, (Set)excludeIfExist);
        ArtifactoryClientConfiguration.addDefaultPublisherAttributes((ArtifactoryClientConfiguration)config, (String)project.getRootProject().getName(), (String)"Gradle", (String)project.getGradle().getGradleVersion());
    }

    private static void fillProperties(Project project, Properties props) {
        Project parent = project.getParent();
        if (parent != null) {
            GradleArtifactoryClientConfigUpdater.fillProperties(parent, props);
        }
        Map projectProperties = project.getExtensions().getExtraProperties().getProperties();
        props.putAll((Map<?, ?>)BuildInfoExtractorUtils.filterStringEntries((Map)projectProperties));
    }
}

