/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.go.extractor;

import com.github.zafarkhaja.semver.Version;
import java.io.File;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;

public class GoVersionUtils {
    public static final String INCOMPATIBLE = "+incompatible";
    public static final int ZERO_OR_ONE = 0;

    public static long getMajorVersion(String version, Log log) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            return 0L;
        }
        Optional parsedVersion = Version.tryParse((String)StringUtils.removeStart((String)(version = GoVersionUtils.getCleanVersion(version)), (String)"v"));
        if (parsedVersion.isPresent()) {
            return ((Version)parsedVersion.get()).majorVersion();
        }
        log.debug("Failed to parse major version of " + version);
        return 0L;
    }

    public static int getMajorProjectVersion(String project, Log log) {
        if (!StringUtils.isEmpty((CharSequence)project) && (project = project.toLowerCase()).matches("^.*/v\\d+")) {
            String major = project.substring(project.lastIndexOf("/v") + 2);
            try {
                return Integer.parseInt(major);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse major version of " + project, (Throwable)e);
            }
        }
        return 0;
    }

    public static String getCleanVersion(String version) {
        if (!StringUtils.isEmpty((CharSequence)version) && version.contains(INCOMPATIBLE)) {
            version = version.substring(0, version.indexOf(INCOMPATIBLE));
        }
        return version;
    }

    public static boolean isCompatibleGoModuleNaming(String projectName, String version, Log log) {
        if (StringUtils.isBlank((CharSequence)projectName) || StringUtils.isBlank((CharSequence)version)) {
            return false;
        }
        long majorVersion = GoVersionUtils.getMajorVersion(version, log);
        if (majorVersion >= 2L) {
            return projectName.endsWith("/v" + majorVersion) && !version.endsWith(INCOMPATIBLE);
        }
        return majorVersion == 1L || majorVersion == 0L;
    }

    public static String getSubModule(String projectName) {
        if (StringUtils.isBlank((CharSequence)projectName)) {
            return "";
        }
        String[] parts = projectName.split("/", 4);
        if (parts.length >= 4) {
            return parts[3];
        }
        return "";
    }

    public static String getParent(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        String parentPath = new File(path).getParent();
        if (StringUtils.isNotEmpty((CharSequence)parentPath)) {
            return parentPath.replace('\\', '/');
        }
        return "";
    }
}

