/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog.plugins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.jfrog.configuration.Credentials;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class PluginsUtils {
    public static StringCredentials accessTokenCredentialsLookup(String credentialsId, Item item) {
        return (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public static Credentials credentialsLookup(String credentialsId, Item item) {
        StringCredentials accessCred = PluginsUtils.accessTokenCredentialsLookup(credentialsId, item);
        if (accessCred != null) {
            return new Credentials(Credentials.EMPTY_SECRET, Credentials.EMPTY_SECRET, accessCred.getSecret());
        }
        UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (Item)item), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (usernamePasswordCredentials != null) {
            return new Credentials(Secret.fromString((String)usernamePasswordCredentials.getUsername()), usernamePasswordCredentials.getPassword(), Credentials.EMPTY_SECRET);
        }
        return Credentials.EMPTY_CREDENTIALS;
    }

    public static ListBoxModel fillPluginCredentials(Item project) {
        List domainRequirements = Collections.emptyList();
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, project, StandardCredentials.class, domainRequirements, CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class)})).includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardCredentials.class, domainRequirements, CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class)}));
    }
}

