/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog.configuration;

import hudson.ProxyConfiguration;
import hudson.util.Secret;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;

public class JenkinsProxyConfiguration
extends org.jfrog.build.client.ProxyConfiguration {
    private static final Pattern HOST_NAME_PATTERN = Pattern.compile("^.*?://?([\\w.-]+).*");
    public List<Pattern> noProxyHostPatterns;
    public String noProxy;

    public JenkinsProxyConfiguration() {
        ProxyConfiguration proxy = Jenkins.get().getProxy();
        if (proxy == null) {
            return;
        }
        this.host = proxy.getName();
        this.port = proxy.getPort();
        this.username = proxy.getUserName();
        this.password = Secret.toString((Secret)proxy.getSecretPassword());
        this.noProxy = proxy.getNoProxyHost();
        this.noProxyHostPatterns = proxy.getNoProxyHostPatterns();
    }

    public boolean isProxyConfigured() {
        return StringUtils.isNotBlank((CharSequence)this.host);
    }

    public boolean isProxyConfigured(String url) {
        return this.isProxyConfigured() && !this.shouldBypassProxy(url);
    }

    public boolean shouldBypassProxy(String url) {
        Matcher matcher = HOST_NAME_PATTERN.matcher(url);
        if (!matcher.matches()) {
            return false;
        }
        String host = matcher.group(1);
        for (Pattern noProxyHostPattern : this.noProxyHostPatterns) {
            if (!noProxyHostPattern.matcher(host).matches()) continue;
            return true;
        }
        return false;
    }
}

